import junit.framework.*;
import Member;

public class MemberTester extends TestCase
{
   private final static String EMAIL_ADDRESS = "TestRow@Nowhere.net";

   private Member m_Member;

   public MemberTester( String name )
   {
      super(name);
      m_Member = new Member();
   }

   public static void main( String[] args )
   {
      junit.textui.TestRunner.run( suite() );
   }

   public static Test suite()
   {
      return new TestSuite( MemberTester.class );
   }

   /*
   * For the uninitiated, CRUD is database lingo for Create, Read, Update, and Delete.
   * Since JUnit creates an instance of a test class for each test case
   * that it executes, I've found it necessary to combine the basic CRUD
   * test into a single test case.
   */
   public void testCRUD()
   {
      StringBuffer errorMessages = new StringBuffer();

      boolean success = create( errorMessages );
      assert( "create failed: " + errorMessages.toString(), success );

      if ( success )
      {
         success = findByEmail();
         assert( "findByEmail failed", success );
      }

      if ( success )
      {
         success = update( errorMessages );
         assert( "update failed: " + errorMessages.toString(), success );
      }

      if ( success )
      {
         success = m_Member.delete( errorMessages );
         assert( "delete failed: " + errorMessages.toString(), success );
      }

      errorMessages = null;
   }

   private boolean create( StringBuffer errorMessages )
   {
      m_Member.setFirstName( "Test" );
      m_Member.setLastName( "Insert" );
      m_Member.setEmail( EMAIL_ADDRESS );
      m_Member.setPassword( "123456" );

      return m_Member.create( errorMessages );
   }

   private boolean findByEmail()
   {
      return m_Member.findByEmail( EMAIL_ADDRESS );
   }

   private boolean update( StringBuffer errorMessages )
   {
      m_Member.setFirstName("Update");
      m_Member.setLastName("Update");
      m_Member.setPassword( "654321" );

      long Now = System.currentTimeMillis();
      m_Member.setRegistrationDate( new java.util.Date(Now) );

      return m_Member.update( errorMessages );
   }
}
